#version 430

layout (location = 0) in smooth vec3 fragViewPos;
layout (location = 1) in smooth vec3 fragNormal;
layout (location = 2) in vec3 noiseCoords;
layout (location = 3) in vec4 fragPosLightSpace;
layout (location = 4) flat in uvec3 fragInstanceID;
layout (location = 5) in float colorBrightness;

layout (location = 0) out vec4 gAlbedoAlpha;
layout (location = 1) out vec4 gPhysical;

layout (binding = 1) uniform sampler2D noiseTex;

layout(binding = 1, rgba16f) uniform readonly restrict image2D playerTex;


uniform mat4 view;

uniform int modelID;

uniform float time;
uniform vec3 starColor;


#define NUM_OCTAVES 5

const float PI = 3.1415926535897932384626433832795;


float linearize_depth(float d,float zNear,float zFar)
{
  float z_n = 2.0 * d - 1.0;
  return 2.0 * zNear * zFar / (zFar + zNear - z_n * (zFar - zNear));
}


float hash(float n) { return fract(sin(n) * 1e4); }
float hash(vec2 p) { return fract(1e4 * sin(17.0 * p.x + p.y * 0.1) * (0.1 + abs(sin(p.y * 13.0 + p.x)))); }

float noise(vec3 x) {
	const vec3 step = vec3(110, 241, 171);

	vec3 i = floor(x);
	vec3 f = fract(x);
 
	// For performance, compute the base input to a 1D hash from the integer part of the argument and the 
	// incremental change to the 1D based on the 3D -> 1D wrapping
    float n = dot(i, step);

	vec3 u = f * f * (3.0 - 2.0 * f);
	return mix(mix(mix( hash(n + dot(step, vec3(0, 0, 0))), hash(n + dot(step, vec3(1, 0, 0))), u.x),
                   mix( hash(n + dot(step, vec3(0, 1, 0))), hash(n + dot(step, vec3(1, 1, 0))), u.x), u.y),
               mix(mix( hash(n + dot(step, vec3(0, 0, 1))), hash(n + dot(step, vec3(1, 0, 1))), u.x),
                   mix( hash(n + dot(step, vec3(0, 1, 1))), hash(n + dot(step, vec3(1, 1, 1))), u.x), u.y), u.z);
}

float rand(float n){return fract(sin(n) * 43758.5453123);}

float rand(vec2 n) { 
	return fract(sin(dot(n, vec2(12.9898, 4.1414))) * 43758.5453);
}


float noise(float p){
	float fl = floor(p);
  float fc = fract(p);
	return mix(rand(fl), rand(fl + 1.0), fc);
}
	
float noise(vec2 n) {
	const vec2 d = vec2(0.0, 1.0);
  vec2 b = floor(n), f = smoothstep(vec2(0.0), vec2(1.0), fract(n));
	return mix(mix(rand(b), rand(b + d.yx), f.x), mix(rand(b + d.xy), rand(b + d.yy), f.x), f.y);
}

float fbm(vec2 x) {
	float v = 0.0;
	float a = 0.5;
	vec2 shift = vec2(100);
	// Rotate to reduce axial bias
    mat2 rot = mat2(cos(0.5), sin(0.5), -sin(0.5), cos(0.50));
	for (int i = 0; i < NUM_OCTAVES; ++i) {
		v += a * noise(x);
		x = rot * x * 2.0 + shift;
		a *= 0.5;
	}
	return v;
}



float fbm (vec3 _st) {
    float v = 0.0;
    float a = 0.5;
    vec3 shift = vec3(100.0f);
    // Rotate to reduce axial bias
    mat2 rot = mat2(cos(0.5), sin(0.5),
                    -sin(0.5), cos(0.50));
    for (int i = 0; i < NUM_OCTAVES; ++i) {
        v += a * noise(_st);
        _st = _st * 2.0 + shift;
        a *= 0.5;
    }
    return v;
}

float fbmFloat (float x) {
	float v = 0.0;
	float a = 0.5;
	float shift = float(100);
	for (int i = 0; i < NUM_OCTAVES; ++i) {
		v += a * noise(x);
		x = x * 2.0 + shift;
		a *= 0.5;
	}
	return v;
}

float atan2(in float y, in float x)
{
    bool s = (abs(x) > abs(y));
    return mix(PI/2.0 - atan(x,y), atan(y,x), s);
}


void main(){
 
	float playerID = float(fragInstanceID.z);

	gPhysical.xyzw = vec4(0.0);

	bool isItEmissive = gPhysical.z > 0.0;
	
	float noiseFreq = 5.0f;

	float firstNoise = fbm(noiseCoords * noiseFreq);

	float finalNoise = abs(sin(time / 5.0 + firstNoise * 10.0f));

	vec3 secondaryColor = mix(starColor, vec3(0.0), 0.5);
	vec3 finalColor = mix(starColor, secondaryColor, finalNoise);

	gAlbedoAlpha.xyzw = vec4(finalColor, 1.0);



}